DECLARE @logName as nvarchar(50)
DECLARE @databaseID as int

DECLARE db_cursor CURSOR FOR  
SELECT TOP 10 name,database_id -- only 10 but you can choose any number
FROM sys.master_Files WHERE physical_name like '%.ldf'
and physical_name not like 'C:\%'  -- specify your database paths
and name not in ('mastlog') -- any database logs that you would like to exclude
ORDER BY size DESC

OPEN db_cursor  
FETCH NEXT FROM db_cursor INTO @logName , @databaseID

WHILE @@FETCH_STATUS = 0  
BEGIN  
    DECLARE @databaseName as nvarchar(50)
 SET @databaseName =  DB_NAME(@databaseID)

  DECLARE @tsql nvarchar(300)
 SET @tsql='USE ['+@databaseName+'] ALTER DATABASE ['+@databaseName+'] set recovery simple DBCC SHRINKFILE ('+@logName+' , 1)'
 EXEC(@tsql)

    FETCH NEXT FROM db_cursor INTO @logName , @databaseID
END  
CLOSE db_cursor
DEALLOCATE db_cursor